<!-- Example: submit signature -->
<form id="signForm">
  <input name="petition_id" type="hidden" value="123">
  <input name="name" required>
  <input name="email" required type="email">
  <textarea name="comment"></textarea>
  <button>Sign</button>
</form>

<script>
document.getElementById('signForm').addEventListener('submit', async function(e){
  e.preventDefault();
  const form = new FormData(e.target);
  const data = Object.fromEntries(form.entries());
  const resp = await fetch('/submit_signature.php', {
    method: 'POST',
    body: JSON.stringify(data),
    headers: {'Content-Type': 'application/json'}
  });
  const json = await resp.json();
  if (json.verify_link) {
    alert('Check your email to confirm your signature.');
  }
});
</script>

<!-- Polling counts -->
<script>
async function pollCount(){
  const res = await fetch('/counts.php?petition_id=123');
  const j = await res.json();
  document.getElementById('sigCount').innerText = j.count;
}
setInterval(pollCount, 5000);
pollCount();
</script>
